package jadean.dean.java.resources;

import jadean.dean.Resource;
import jadean.dean.exceptions.ResourceIOException;
import jadean.dean.exceptions.ResourceInvalidException;
import jadean.dean.exceptions.ResourceNotFoundException;
import jadean.dean.java.JavaPackage;
import jadean.dean.java.JavaProject;
import jadean.dean.java.JavaResource;
import jadean.dean.java.resourceparser.JavaResourceParser;
import jadean.dean.java.resourceparser.classparser.ClassResourceParser;
import jadean.dean.java.resourceparser.javaparser.JavaSourceResourceParser;
import jadean.dean.java.utilities.FileUtilities;
import jadean.dean.java.utilities.ProjectUtilities;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;


public class JavaResourceProjectClass extends JavaResourceProjectResource {
	
	public JavaResourceProjectClass(String name, JavaResourceContext context, JavaProject p) {
		super(name, context, p);
	}

	@Override
	public Collection<Resource> getReferrencedResources() {
		try {
			String fileName = FileUtilities.findInDirs(this.getProject().getSourceFolders(), this.getName().replace('.', File.separatorChar) + ".java");
			JavaResourceParser jrp = null;
			if (fileName == null) {
				jrp = new ClassResourceParser(this.getProject().getOutputFolder() +  this.getName().replace('.', File.separatorChar) + ".java");
			}
			else {
				jrp = new JavaSourceResourceParser(fileName);
			}
			Collection<Resource> s = jrp.getReferencedResources();
			ArrayList<Resource> ret = new ArrayList<Resource>();
			JavaResourceFactory rf = new JavaResourceFactory(this.getProject());
			for (Resource resource: s) {
				JavaResource javaResource = (JavaResource) resource;
				ret.add(rf.classNameToResource(javaResource.getName(), javaResource.getContext()));
			}
			if (jrp.isReflectionUsed()) {
				getProject().setReflectionUsed(true);
			}	
			return ProjectUtilities.deDuplicateResources(ProjectUtilities.normalizeResources(ret, this.getProject()));
		}
		catch (ResourceNotFoundException e) {
			return new ArrayList<Resource>();
		}
		catch (ResourceIOException e) {
			return new ArrayList<Resource>();
		}
		catch (ResourceInvalidException e) {
			return new ArrayList<Resource>();
		}
	}

	@Override
	public JavaPackage getPackageForResource() {
		return null;
	}

	@Override
	public void delete() {
		File classFile = new File(FileUtilities.findInDirs(this.getProject().getSourceFolders(), this.getName().replace('.', File.separatorChar) + ".java"));
		classFile.delete();
	}

}
